/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.zurrtum.create.client.model.StandardModelParameters;
import com.zurrtum.create.client.model.UnbakedModelLoader;
import com.zurrtum.create.client.model.obj.ObjGeometry;
import com.zurrtum.create.client.model.obj.ObjMaterialLibrary;
import com.zurrtum.create.client.model.obj.ObjModel;
import com.zurrtum.create.client.model.obj.ObjTokenizer;
import com.zurrtum.create.foundation.utility.CreateResourceReloader;
import java.io.FileNotFoundException;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class ObjLoader
extends CreateResourceReloader
implements UnbakedModelLoader<ObjModel> {
    public static ObjLoader INSTANCE = new ObjLoader();
    private final Map<ObjGeometry.Settings, ObjGeometry> geometryCache = Maps.newConcurrentMap();
    private final Map<class_2960, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private final class_3300 manager = class_310.method_1551().method_1478();

    public ObjLoader() {
        super("model");
    }

    public void method_14491(class_3300 resourceManager) {
        this.geometryCache.clear();
        this.materialCache.clear();
    }

    @Override
    public ObjModel read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonObject.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        boolean automaticCulling = class_3518.method_15258((JsonObject)jsonObject, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = class_3518.method_15258((JsonObject)jsonObject, (String)"shade_quads", (boolean)true);
        boolean flipV = class_3518.method_15258((JsonObject)jsonObject, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = class_3518.method_15258((JsonObject)jsonObject, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = class_3518.method_15253((JsonObject)jsonObject, (String)"mtl_override", null);
        StandardModelParameters parameters = StandardModelParameters.parse(jsonObject, jsonDeserializationContext);
        ObjGeometry geometry = this.loadGeometry(new ObjGeometry.Settings(class_2960.method_60654((String)modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, parameters));
        return new ObjModel(parameters, geometry);
    }

    public ObjGeometry loadGeometry(ObjGeometry.Settings settings) {
        return this.geometryCache.computeIfAbsent(settings, data -> {
            ObjGeometry objGeometry;
            class_3298 resource = (class_3298)this.manager.method_14486(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.method_14482());
            try {
                objGeometry = ObjGeometry.parse(tokenizer, data);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objGeometry;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(class_2960 materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            class_3298 resource = (class_3298)this.manager.method_14486(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.method_14482());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

